/*
 * Decompiled with CFR 0.152.
 */
import java.util.Calendar;
import java.util.Date;

public class CalendarInfo {
    private int year;
    private int month;
    private int date;
    private int length;
    private int dayOfWeek;
    private static final int[] MONTH_DATE = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public CalendarInfo() {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        long l = date.getTime();
        date.setTime(l += 32400000L);
        calendar.setTime(date);
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.date = calendar.get(5);
        this.init();
    }

    public CalendarInfo(int n, int n2, int n3) {
        this.year = n;
        this.month = n2;
        if (this.month < 1 && this.month > 12) {
            throw new IllegalArgumentException(" month :" + this.month);
        }
        if (n3 <= 0) {
            this.date = 0;
            n3 = 1;
        } else {
            this.date = n3;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, this.year);
        calendar.set(2, this.month);
        calendar.set(5, n3);
        calendar.set(11, 0);
        this.init();
    }

    public int getDate() {
        return this.date;
    }

    public int getDayOfWeek() {
        return this.dayOfWeek;
    }

    public static int getDayOfWeek(int n, int n2, int n3) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, n);
        calendar.set(2, n2 - 1);
        calendar.set(5, n3);
        return calendar.get(7);
    }

    public static int getLastDate(int n, int n2) {
        if (n2 == 2) {
            if (CalendarInfo.isUruu(n)) {
                return 29;
            }
            return 28;
        }
        return MONTH_DATE[n2 - 1];
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    private void init() {
        this.length = CalendarInfo.getLastDate(this.year, this.month);
        this.dayOfWeek = CalendarInfo.getDayOfWeek(this.year, this.month, 1) - 1;
    }

    public static boolean isUruu(int n) {
        if (n % 4 != 0) {
            return false;
        }
        if (n % 100 != 0) {
            return true;
        }
        return n % 400 == 0;
    }

    public int length() {
        return this.length;
    }
}

