/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SchedulerCanvas
extends Canvas {
    public static int year;
    public static int month;
    private int date;
    private int[][] dateboard = new int[6][7];
    Image week;
    int whichday;
    String todaySt = "";
    private CalendarInfo calInfo = new CalendarInfo();
    public boolean calendarChanged = false;
    private boolean painted = false;
    private int nowV;
    private int nowH;
    private int oldV = 0;
    private int oldH = 0;
    static String[] datalist;
    private boolean havePlan;

    public SchedulerCanvas() {
        year = this.calInfo.getYear();
        month = this.calInfo.getMonth();
        this.date = this.calInfo.getDate();
        this.todaySt = String.valueOf(year) + "/ " + month + "/ " + this.date;
        this.whichday = this.calInfo.getDayOfWeek();
        int n = 1 - this.whichday;
        int n2 = 0;
        while (n2 < 6) {
            int n3 = 0;
            while (n3 < 7) {
                this.dateboard[n2][n3] = n < 1 || n > this.calInfo.length() ? 0 : n;
                if (n == this.date) {
                    this.nowV = n2;
                    this.nowH = n3;
                }
                ++n;
                ++n3;
            }
            ++n2;
        }
        try {
            this.week = Image.createImage((String)"/week.png");
        }
        catch (IOException iOException) {}
        this.calendarChanged = true;
    }

    public void changeMonth(int n) {
        int n2 = month + n;
        if (n2 < 1) {
            n2 = 12;
            --year;
        } else if (n2 > 12) {
            n2 = 1;
            ++year;
        }
        this.calInfo = new CalendarInfo(year, n2, 1);
        year = this.calInfo.getYear();
        month = this.calInfo.getMonth();
        this.date = this.calInfo.getDate();
        this.whichday = this.calInfo.getDayOfWeek();
        int n3 = 1 - this.whichday;
        int n4 = 0;
        while (n4 < 6) {
            int n5 = 0;
            while (n5 < 7) {
                this.dateboard[n4][n5] = n3 < 1 || n3 > this.calInfo.length() ? 0 : n3;
                ++n3;
                ++n5;
            }
            ++n4;
        }
        this.calendarChanged = true;
        this.repaint();
    }

    public boolean focusChk() {
        return this.nowV > -1 && this.dateboard[this.nowV][this.nowH] != 0;
    }

    public String getFocusedDate() {
        String string = null;
        if (this.nowH == 0) {
            string = "Sun";
        } else if (this.nowH == 1) {
            string = "Mon";
        } else if (this.nowH == 2) {
            string = "Tue";
        } else if (this.nowH == 3) {
            string = "Wed";
        } else if (this.nowH == 4) {
            string = "Thu";
        } else if (this.nowH == 5) {
            string = "Fri";
        } else if (this.nowH == 6) {
            string = "Sat";
        }
        return " " + year + " / " + month + " / " + this.dateboard[this.nowV][this.nowH] + " " + string;
    }

    public String getFocusedDateSearch() {
        return String.valueOf(year) + "y" + month + "m" + this.dateboard[this.nowV][this.nowH];
    }

    protected void keyPressed(int n) {
        if (!this.painted) {
            return;
        }
        this.painted = false;
        this.oldV = this.nowV--;
        this.oldH = this.nowH--;
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 1: {
                if (this.nowV < -1) {
                    this.nowV = -1;
                }
                this.repaint();
                return;
            }
            case 6: {
                ++this.nowV;
                if (this.nowV > 5) {
                    this.nowV = 5;
                }
                this.repaint();
                return;
            }
            case 2: {
                if (this.nowV < 0) {
                    this.changeMonth(-1);
                    return;
                }
                if (this.nowH < 0) {
                    if (this.nowV > 0) {
                        --this.nowV;
                        this.nowH = 6;
                    } else {
                        this.nowV = -1;
                        this.nowH = 0;
                    }
                }
                this.repaint();
                return;
            }
            case 5: {
                if (this.nowV < 0) {
                    this.changeMonth(1);
                    return;
                }
                ++this.nowH;
                if (this.nowH > 6) {
                    if (this.nowV < 5) {
                        ++this.nowV;
                        this.nowH = 0;
                    } else {
                        this.nowV = -1;
                        this.nowH = 6;
                    }
                }
                this.repaint();
                return;
            }
            case 8: {
                this.repaint();
                return;
            }
        }
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (this.calendarChanged) {
            graphics.setColor(4023029);
            graphics.fillRect(0, 0, 96, 100);
            graphics.setColor(0xFFFFFF);
            graphics.setFont(Font.getFont((int)0, (int)1, (int)0));
            graphics.drawString(String.valueOf(year) + " / " + month, 48, 0, 17);
            graphics.drawImage(this.week, 2, 13, 20);
            graphics.setColor(26112);
            graphics.fillRect(0, 89, 96, 100);
            graphics.setColor(0xFFFFFF);
            graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
            graphics.drawString("Today: " + this.todaySt, 4, 89, 20);
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(2, 21, 91, 66);
            int n = 0;
            while (n < 6) {
                int n2 = 0;
                while (n2 < 7) {
                    if (this.dateboard[n][n2] > 0) {
                        String string = String.valueOf(year) + "y" + month + "m" + this.dateboard[n][n2];
                        this.havePlan = false;
                        int n3 = 0;
                        while (n3 < datalist.length) {
                            if (string.equals(datalist[n3])) {
                                this.havePlan = true;
                            }
                            ++n3;
                        }
                        if (this.havePlan) {
                            graphics.setFont(Font.getFont((int)0, (int)4, (int)8));
                            graphics.setColor(0xFFFF00);
                            graphics.fillRect(n2 * 13 + 5, n * 11 + 21, 9, 7);
                        } else {
                            graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
                        }
                        if (n2 == 0) {
                            graphics.setColor(0xFF0000);
                        } else if (n2 == 6) {
                            graphics.setColor(255);
                        } else {
                            graphics.setColor(0);
                        }
                        graphics.drawString(String.valueOf(this.dateboard[n][n2]), n2 * 13 + 14, n * 11 + 21, 24);
                    }
                    ++n2;
                }
                ++n;
            }
            this.calendarChanged = false;
        }
        if (this.oldV < 0) {
            graphics.setColor(4023029);
            graphics.fillArc(15, 2, 12, 9, 90, 180);
            graphics.fillArc(69, 2, 12, 9, 270, 180);
        } else {
            graphics.setColor(0xFFFFFF);
            graphics.drawRect(this.oldH * 13 + 3, this.oldV * 11 + 21, 11, 11);
        }
        if (this.nowV < 0) {
            graphics.setColor(0xFFFF00);
            graphics.fillArc(15, 2, 12, 9, 90, 180);
            graphics.fillArc(69, 2, 12, 9, 270, 180);
        } else {
            graphics.setColor(0xCC0000);
            graphics.drawRect(this.nowH * 13 + 3, this.nowV * 11 + 21, 11, 11);
        }
        this.painted = true;
    }
}

